<?php

/**
 *
 * INDEXU
 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */
 
  /*===================================================
    ShowFormReview()
  ===================================================*/
  
  function ShowFormReview() {

    // vars global configuration
    global $dbConn, $theme_path, $category_separator, 
             $only_registered_can_add_review, $rev_no_login;

    // vars url & form
    global $id;

    // vars messages
    global $msg;

    // vars template
    global $username, $rev_name, $rev_email, $rev_subject, $rev_rating, $rev_review, $error_msg;

    $tpl = new Template();

    $links_obj = new clsLink;
    $links_obj->query               = "select * from idx_link where link_id = '$id'";
    $links_obj->table_name          = "idx_link";
    $links_obj->category_table_name = "idx_category";
    $links_obj->category_separator  = $category_separator;
    $links_obj->max_rows            = 1;
    $links_obj->date_format         = $msg["10161"];
    $links_obj->template_file       = $theme_path . "review_form.html";
    $review_form                    = $links_obj->Display();

    $rev_no_login = false;

    $tpl->assign('username', $_COOKIE['COOKIE_USERNAME']);
    
    if(empty($_COOKIE['COOKIE_USERNAME'])) {
      $rev_no_login = true;
      $tpl->assign('rev_name', htmlspecialchars(stripslashes($rev_name)));
      $tpl->assign('rev_email', htmlspecialchars(stripslashes($rev_email)));
    }

    $tpl->assign('rev_subject', htmlspecialchars(stripslashes($rev_subject)));
    $tpl->assign('rev_rating', $rev_rating);
    $tpl->assign('rev_review', htmlspecialchars(stripslashes($rev_review)));
    $tpl->assign('id', $id);
    $tpl->assign('error_msg', $error_msg);
    $tpl->assign('rev_no_login', $rev_no_login);
    $review_form = $tpl->fetch('var:' . str_replace(array('<%literal%>', '<%/literal%>'), '', $review_form));

    print $review_form;
  }


  /*===================================================
    ProcessFormReview()
  ===================================================*/
  
  function ProcessFormReview() {

    // vars global configuration
    global $only_registered_can_add_review, $theme_path, $category_separator, $email_address;

    // vars url & form
    global $username, $rev_subject, $rev_rating, $rev_review, $id, $rev_name, $rev_email;

    // vars messages
    global $msg;

    // vars template
    global $error_msg, $category;

    // verify input

    if (empty($rev_subject))
      $error_msg = $msg["10181"];
    elseif (empty($rev_rating))
      $error_msg = $msg["10182"];
    elseif (empty($rev_review))
      $error_msg = $msg["10183"];
      
    elseif(empty($_COOKIE['COOKIE_USERNAME']) && empty($rev_name))
     $error_msg = $msg["10186"];
    elseif(empty($_COOKIE['COOKIE_USERNAME']) && empty($rev_email))
     $error_msg = $msg["10184"];

    if(empty($error_msg)) {
      // get field
      $links_obj = new clsLink;
      $links_obj->table_name          = "idx_link";
      $links_obj->category_table_name = "idx_category";
      $links_obj->editor_table_name   = "idx_editor";
      $links_obj->user_table_name     = "idx_users";
      $links_obj->review_table_name   = "idx_review";
      $review_result                  = $links_obj->Review("process_form", $id, $username, $rev_subject, $rev_rating,
                                                            $rev_review, $rev_name, $rev_email);
      $cat                            = $links_obj->GetLinkCategoryId($id);

      $category_obj = new clsCategory;
      $category_obj->table_name = "idx_category";
      $category_obj->separator  = $category_separator;
      $category                 = $category_obj->GetCategoryPath($cat);

      $users_obj = new clsUsers;
      $users_obj->table_name = "idx_users";

      // successfully added

      if ($review_result == 0) {

        // send email to all editors and admin

        $emails   = $links_obj->GetEditorEmail($cat);
        $emails[] = $email_address;

        while (list(, $v) = @each($emails)) {
          $body = EvalTemplate($theme_path . "mail/review_pending_editor.mail", $links_obj->email_template_fields);
          $from = $email_address;
          @mail($v, $msg["10191"], $body, "From: $from \nX-Mailer: INDEXU_X-Mailer/1.0");
        }

        DisplayTemplate($theme_path . "review_ok.html");
      }
    }
    else {
      ShowFormReview();
    }
  }


  /*===================================================
    main
  ===================================================*/

  include "application.php";

  RunPreFilter(__FILE__);

  $query     = "select suspended from idx_link where link_id = '$id'";
  $result    = $dbConn->Execute($query);
  $suspended = $result->Fields("suspended");

  if ($suspended) {
    DisplayTemplate($theme_path . "suspended.html");
    RunPostFilter(__FILE__);
  }

  if ($only_registered_can_add_review) {
    ExecuteFilter("validate_user");
  }

  if (empty($pflag)) {
    ShowFormReview();
  }
  elseif ($pflag == 'review') {
    ProcessFormReview();
  }

  RunPostFilter(__FILE__);

?>